#include "coresincro.cslib";


void bubble_sort_order_proc(string array[],int size) {
 for(int i = 0; i < size - 1; i++) 
 {
   for(int j = i + 1; j < size; j++) 
   {
    if(this->CharToInt(this->Split(array[j],'|',0)) < this->CharToInt(this->Split(array[i],'|',0)) ) 
    {
       string v = array[i];
       array[i] = array[j];
       array[j] = v;
     }
   }
 }

}

void main()
{

 this->WriteLog(1,"START CORESINCRO","CRON");

 CS_FileSystem sys = new CS_FileSystem();
 CS_FileCfg    sincrocfg = new CS_FileCfg();

 sincrocfg->Load(sys->AppPath() + "/coresincro.cfg");

 // connect to master
 if (this->StrLen(sincrocfg->ReadVar("MASTER_SERVER","ip")) == 0 || this->StrLen(sincrocfg->ReadVar("MASTER_SERVER","port")) == 0 || this->StrLen(sincrocfg->ReadVar("MASTER_SERVER","key")) == 0)
 {
 this->WriteLog(1,"CORESINCRO CFG ERROR","CRON");
 delete sys;
 delete sincrocfg;
 return;
 }

 masterconn = this->GetPersistentOBJ("coresincro_master_conn","CaronteServerConn");

 if (masterconn == NULL)
 {
   masterconn = this->CreatePersistentOBJ("coresincro_master_conn","CaronteServerConn");
  if (masterconn == NULL)
  {
    delete sys;
    delete sincrocfg;
    this->WriteLog(1,"CORESINCRO CreatePersistentOBJ ERROR","CRON");
    return;
  }
 } 


 masterconn->SetOptions(sincrocfg->ReadVar("MASTER_SERVER","ip"),sincrocfg->ReadVar("MASTER_SERVER","port"),sincrocfg->ReadVar("MASTER_SERVER","key"));
 masterconn->SetTimeOut(5000);
 
 if (!masterconn->Connect())
 {
   this->DeletePersistentOBJ("coresincro_master_conn");
   delete sys;
   delete sincrocfg;
   this->WriteLog(1,"CORESINCRO Connect to MasterServer ERROR","CRON");
   return;
 }

 //TEST CONN
 CaronteRecordSet rs = new CaronteRecordSet(masterconn);
 rs->Reset();
 rs->AddNew();
 rs->SetFieldAt(1,"TEST PING PONG FROM SLAVE");
 rs->Query(1);
 if (rs->GetLastError() != CR_ACK)
 {
   masterconn->Disconnect();
   int error = rs->GetLastError();
   delete rs;
   delete sys;
   delete sincrocfg;
   this->WriteLog(1,this->Format("CORESINCRO Connect to MasterServer ERROR: %d",error),"CRON");
   this->DeletePersistentOBJ("coresincro_master_conn");
   return;
 }

 // FLAG for plugin to use coresincro

 m_fReload_domain  = this->GetPersistentOBJ("flag_reload_domain","CS_Flag");
 m_fReload_allConf = this->GetPersistentOBJ("flag_reload_conf","CS_Flag");

 if (m_fReload_domain == NULL)
      m_fReload_domain = this->CreatePersistentOBJ("flag_reload_domain","CS_Flag");

 if (m_fReload_allConf == NULL)
      m_fReload_allConf = this->CreatePersistentOBJ("flag_reload_conf","CS_Flag");


if (m_fReload_domain == NULL || m_fReload_allConf == NULL)
  {
    delete sys;
    delete sincrocfg;
    delete rs;
    this->DeletePersistentOBJ("coresincro_master_conn");
    this->WriteLog(1,"CORESINCRO CreatePersistentOBJ ERROR","CRON");
    return;
  }

  m_fReload_domain->SetBool(false);
  m_fReload_allConf->SetBool(false);


 HashArray     aproctmp = new HashArray();
 sincrocfg->GetConfigToArray(aproctmp,"SINCRO");
 int sizea = aproctmp->GetRecordCount() + 1;
 

 string aproc[sizea];
 int count = 0;

 for (int i = 0; i < aproctmp->GetRecordCount(); i++)
 {
  aproc[i] = aproctmp->GetByIndexS(i);
 }

 bubble_sort_order_proc(aproc,sizea);


 //
 for (int i = 0; i < sizea; i++)
 {
  string cmd = this->Split(aproc[i],'|',1);
  string commprocedure = this->Split(aproc[i],'|',2);
  

  //GETMASTERFILE
  if (this->REeq(cmd,"^GETMASTERFILE\\((.+?),(.+?),(.+?)\\)$",0) == true)
  {
    if ( (this->Lc(this->$3()) == "md5" && Md5Compare(this->$1(), this->Replace(this->$2(),"{ROOT}",sys->AppPath())) == true) ||  this->Lc(this->$3()) == "forze")
    {
      if (GetMasterFile(this->$1(), this->Replace(this->$2(),"{ROOT}",sys->AppPath())) == true)
       {
        if (this->REeq(commprocedure,"^IFCOPY\\{(.+?)\\}$",0) == true)
        {
          string ifcopy = this->$1();
          if (this->REeq(ifcopy,"^SLAVESCRIPT\\((.+?)\\)$",0) == true)
          {
            this->WriteLog(1,"CORESINCRO RUN: " + this->$1(),"CRON");
            this->RunScript(this->$1());
           }
         }      
        } else
           {
            this->WriteLog(1,this->Format("CORESINCRO ERROR Trasfert file: %s", this->$1()),"CRON");
           }
    }
  } 
  
  ///GETMASTERCONFIG
  if (this->REeq(cmd,"^GETMASTERCONFIG\\((.+?),(.+?),(.+?)\\)$",0) == true)
  {
   
   aproctmp->Reset();
   string label = this->$1();
   string key   = this->$2();
   string mdf = this->Lc(this->$3());

   if (GetMasterConfig( label,  key, aproctmp) == true)
   {
    if ( (mdf == "md5" && CompareConfig(label, aproctmp) == true) ||  mdf == "forze")
    {
     UpDateSlaveConfig(label,key,aproctmp);
     m_fReload_allConf->SetBool(true);
     if (this->REeq(commprocedure,"^IFCOPY\\{(.+?)\\}$",0) == true)
      {
       string ifcopy = this->$1();
          if (this->REeq(ifcopy,"^SLAVESCRIPT\\((.+?)\\)$",0) == true)
          {
            this->WriteLog(1,"CORESINCRO RUN: " + this->$1(),"CRON");
            this->RunScript(this->$1());
           }
      } 

    }

   } else 
     {
       //If delete from master config ?
       //then controll local config
       aproctmp->Reset();
       if (this->GetConfigToArray(aproctmp,label) == true)
       {
         for (int i = 0; i < aproctmp->GetRecordCount(); i++)
         {
          if (this->REeq(aproctmp->GetKeyByIndex(i),key,RE_CASELESS) == true)
          {
           this->DeleteFromConfig(label,aproctmp->GetKeyByIndex(i));
           m_fReload_allConf->SetBool(true);
          }      
	 }
       }

     }
  }


  if (this->REeq(commprocedure,"^SLAVESCRIPT\\((.+?)\\)$",0) == true)
  {
   this->WriteLog(1,"CORESINCRO RUN: " + this->$1(),"CRON");
   this->RunScript(this->$1());
  }
 
}


// case REBOOT
if (m_fReload_domain->GetBool() == true)
  this->LoadDomainsConfig();


if (m_fReload_allConf->GetBool() == true)
{
  this->WaitForReplaceConfig();
  this->SaveConfig();
  this->SetLevelReBootConfig(0); //automatic
  this->SetRebootConfig(true);
}

 
 delete sys;
 delete sincrocfg;
 delete aproctmp;
 masterconn->Disconnect();
 this->DeletePersistentOBJ("coresincro_master_conn");
 this->DeletePersistentOBJ("flag_reload_domain");
 this->DeletePersistentOBJ("flag_reload_conf");

this->WriteLog(1,"END CORESINCRO","CRON");

}
